/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.idempiere.print.renderer.DelimitedReportRendererConfiguration;
import org.idempiere.print.renderer.IReportRenderer;

public abstract class DelimitedReportRenderer<C extends DelimitedReportRendererConfiguration>
implements IReportRenderer<C> {
    private static final CLogger log = CLogger.getCLogger(DelimitedReportRenderer.class);

    @Override
    public void renderReport(ReportEngine reportEngine, C configuration) {
        try {
            Writer fw = null;
            fw = ((DelimitedReportRendererConfiguration)configuration).getOutputFile() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(((DelimitedReportRendererConfiguration)configuration).getOutputFile(), false), Ini.getCharset()) : ((DelimitedReportRendererConfiguration)configuration).getOutputWriter();
            this.createdDelimitedOutput(reportEngine, fw, ((DelimitedReportRendererConfiguration)configuration).getDelimiter(), ((DelimitedReportRendererConfiguration)configuration).getLanguage());
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean createdDelimitedOutput(ReportEngine reportEngine, Writer writer, char delimiter, Language language) {
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        PrintData printData = reportEngine.getPrintData();
        LayoutEngine layout = reportEngine.getLayout();
        if (delimiter == '\u0000') {
            delimiter = (char)9;
        }
        try {
            ArrayList<Object> columns = new ArrayList<Object>();
            ArrayList<Object> asiElements = new ArrayList<Object>();
            int columnCount = 0;
            int col = 0;
            while (col < printFormat.getItemCount()) {
                MPrintFormatItem mPrintFormatItem = printFormat.getItem(col);
                if (mPrintFormatItem.isPrinted()) {
                    if (mPrintFormatItem.isTypeField() && mPrintFormatItem.isPrintInstanceAttributes()) {
                        InstanceAttributeData asiElement = new InstanceAttributeData(mPrintFormatItem, columnCount);
                        asiElement.readAttributesData(printData);
                        asiElements.add(asiElement);
                    } else {
                        columns.add(mPrintFormatItem);
                        ++columnCount;
                    }
                }
                ++col;
            }
            if (asiElements.size() > 0) {
                int columnCreated = 0;
                for (InstanceAttributeData instanceAttributeData : asiElements) {
                    List<InstanceAttributeColumn> instanceColumns = instanceAttributeData.getColumns();
                    int index = instanceAttributeData.getColumnIndex() + columnCreated;
                    for (InstanceAttributeColumn c : instanceColumns) {
                        columns.add(index, c);
                        ++index;
                        ++columnCreated;
                    }
                }
            }
            Boolean[] colSuppressRepeats = layout == null || layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(printFormat) : layout.colSuppressRepeats;
            Object var12_17 = null;
            if (colSuppressRepeats != null) {
                Object[] objectArray = new Object[colSuppressRepeats.length];
            }
            int printColIndex = -1;
            int row = -1;
            while (row < printData.getRowCount()) {
                printColIndex = -1;
                StringBuffer sb = new StringBuffer();
                if (row != -1) {
                    printData.setRowIndex(row);
                }
                boolean first = true;
                int col2 = 0;
                while (col2 < columns.size()) {
                    block21: {
                        String data;
                        block24: {
                            Object obj;
                            block25: {
                                void var12_19;
                                block23: {
                                    InstanceAttributeColumn iaColumn;
                                    MPrintFormatItem item;
                                    block22: {
                                        Object colObj = columns.get(col2);
                                        item = null;
                                        iaColumn = null;
                                        if (colObj instanceof InstanceAttributeColumn) {
                                            iaColumn = (InstanceAttributeColumn)colObj;
                                            item = iaColumn.getPrintFormatItem();
                                        } else if (colObj instanceof MPrintFormatItem) {
                                            item = (MPrintFormatItem)colObj;
                                        }
                                        if (item == null) break block21;
                                        if (first) {
                                            first = false;
                                        } else {
                                            sb.append(delimiter);
                                        }
                                        if (row != -1) break block22;
                                        String printName = iaColumn != null ? iaColumn.getName() : item.getPrintName(language);
                                        this.addDelimitedValue(sb, delimiter, printName);
                                        break block21;
                                    }
                                    ++printColIndex;
                                    obj = iaColumn != null ? iaColumn.getPrintDataElement(row) : printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
                                    data = "";
                                    if (obj != null && ReportEngine.isDisplayPFItem(printData, item)) break block23;
                                    if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                                        var12_19[printColIndex] = null;
                                    }
                                    break block24;
                                }
                                if (!(obj instanceof PrintDataElement)) break block25;
                                PrintDataElement pde = (PrintDataElement)obj;
                                data = pde.isPKey() ? pde.getValueAsString() : pde.getValueDisplay(language);
                                if (colSuppressRepeats == null || !colSuppressRepeats[printColIndex].booleanValue()) break block24;
                                if (data.equals(var12_19[printColIndex])) break block21;
                                var12_19[printColIndex] = data;
                                break block24;
                            }
                            if (!(obj instanceof PrintData)) {
                                log.log(Level.SEVERE, "Element not PrintData(Element) " + String.valueOf(obj.getClass()));
                            }
                        }
                        this.addDelimitedValue(sb, delimiter, data);
                    }
                    ++col2;
                }
                writer.write(sb.toString());
                writer.write(Env.NL);
                ++row;
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
            return false;
        }
        return true;
    }

    private void addDelimitedValue(StringBuffer sb, char delimiter, String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        boolean needMask = false;
        StringBuilder buff = new StringBuilder();
        char[] chars = content.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\"') {
                needMask = true;
                buff.append(c);
            } else if (!(needMask || c != delimiter && Character.isLetterOrDigit(c))) {
                needMask = true;
            }
            buff.append(c);
            ++i;
        }
        if (needMask) {
            sb.append('\"').append((CharSequence)buff).append('\"');
        } else {
            sb.append((CharSequence)buff);
        }
    }
}

